const express = require("express");
const bodyParser = require("body-parser");
const cors = require("cors");
const dotenv = require("dotenv");
const videoRouter = require("./routes/video");

// Load environment variables from .env file
dotenv.config();

const app = express();

// testing github repo 

// Enable CORS
app.use(cors());

// Parse incoming requests with JSON payloads
app.use(bodyParser.json({ limit: '50mb'}));
app.use(bodyParser.urlencoded({ limit: '50mb', extended: true}));
// Use the video router
app.use("/video", videoRouter);

// Listen on port specified in environment variable, defaulting to 3500
const PORT = process.env.PORT || 3500;
app.listen(PORT, () => {
  console.log(`Server is running on port ${PORT}`);
});
