const multer = require('multer');
const path = require('path');

// Multer configuration for storing videos
const storage = multer.diskStorage({
    destination: function (req, file, cb) {
        cb(null, './input_video'); // Define the destination folder where videos will be stored
    },
    filename: function (req, file, cb) {
        cb(null, Date.now() + path.extname(file.originalname)); // Define the filename
    }
});

// Filter function to restrict file types
const fileFilter = (req, file, cb) => {
    if (file.mimetype.startsWith('video/')) {
        cb(null, true);
    } else {
        cb(new Error('Only videos are allowed!'), false);
    }
};

// Set up multer for video uploads
const Videofileupload = multer({ storage: storage, fileFilter: fileFilter });

// Export the Videofileupload middleware
module.exports.Videofileupload = Videofileupload;
