const fs = require('fs');
const path = require('path');

async function checkOutputVideoPathExist(outputVideoPath, retries = 3, delay = 1000) {
    let retryCount = 0;

    while (retryCount < retries) {
        if (fs.existsSync(outputVideoPath)) {
            console.log(`Output video path "${outputVideoPath}" exists.`);
            return true;
        } else {
            retryCount++;
            console.log(`Output video path "${outputVideoPath}" does not exist. Retrying... (${retryCount}/${retries})`);
            await new Promise(resolve => setTimeout(resolve, delay));
        }
    }

    console.error(`Unable to find output video path "${outputVideoPath}" after ${retries} retries.`);
    return false;
}

module.exports.checkOutputVideoPathExist = checkOutputVideoPathExist;